﻿export function questionManagerInstance() {
    return {
        dispose: () => {

        }
    }
}

export function selectQuestion(questionTypeBorder, questionBorder) {
    //select question
    if (questionBorder.classList.contains("selected") !== "true") {
        var isElementHeightGreaterThanViewport = (questionBorder.offsetTop + questionTypeBorder.offsetHeight) > questionBorder.offsetParent.clientHeight;
        if (isElementHeightGreaterThanViewport) {
            questionTypeBorder.setAttribute("style", "visibility:visible; bottom:43px");
        }
        else {
            questionTypeBorder.setAttribute("style", "visibility:visible; top:" + (questionBorder.offsetTop - 25) + "px");
        }
    }
    else {
        questionTypeBorder.setAttribute("style", "visibility:hidden");
    }
}

export function countBoxAdjustDistanceToCenter(countBorder, questionBorder) {
    countBorder.setAttribute("style", "left:" + (questionBorder.offsetParent.offsetLeft - countBorder.clientWidth + 45) + "px");
    var pixelRatio = window.devicePixelRatio || window.screen.availWidth / document.documentElement.clientWidth;

    window.addEventListener("resize", function () {
        var newPixelRatio = window.devicePixelRatio || window.screen.availWidth / document.documentElement.clientWidth;
        if (newPixelRatio != pixelRatio) {
            pixelRatio = newPixelRatio;
        } 
        countBorder.setAttribute("style", "left:" + (questionBorder.offsetParent.offsetLeft - countBorder.clientWidth + 45) + "px");
    });
}

export function selectQuestionType(questionType) {
    unselectAllQuestionTypes();

    switch (questionType) {
        case 1:
            setQuestionType(document.getElementById("radio-button-question-type"));
            break;
        case 3:
            setQuestionType(document.getElementById("checkbox-question-type"));
            break;
        case 6:
            setQuestionType(document.getElementById("text-answer-question-type"));
            break;
        case 7:
            setQuestionType(document.getElementById("numeric-answer-question-type"));
            break;
        case 21:
            setQuestionType(document.getElementById("description-question-type"));
            break;
    }
}

export function deleteQuestion() {
    unselectAllQuestionTypes();
    document.querySelector(".question-type-border").style.visibility = "hidden";
}

function setQuestionType(questionType) {
    questionType.classList.add("selected");
    (questionType.getElementsByClassName("question-type-item")[0]).classList.add("selected");
    questionType.setAttribute("selected", "true");
}

export function changeQuestionType(questionType) {
    // find selected question
    const questionBorders = document.getElementsByClassName("question-border");
    for (const item of questionBorders) {
        if (item.classList.contains("selected")) {
            selectQuestionType(questionType);
        }
    }
}

function unselectAllQuestionTypes() {
    // select appropriate question type for the question
    const questionTypeBorders = document.getElementsByClassName("question-type");

    for (const item of questionTypeBorders) {
        if (item.getAttribute("selected") == "true") {
            item.classList.remove("selected");
            (item.getElementsByClassName("question-type-item")[0]).classList.remove("selected");
        }
    }
}